/*
 * Decompiled with CFR 0.152.
 */
package de.dhbw.ka.se2.vecto4j.input;

import java.io.Serializable;
import java.util.Objects;

public class Temperature
implements Serializable {
    private static final long serialVersionUID = 6685284408292648016L;
    private double celsius;

    public static Temperature createFromCelsius(double celsius) {
        return new Temperature(celsius);
    }

    public static Temperature createFromFahrenheit(double fahrenheit) {
        return new Temperature(Temperature.celsiusFromFahrenheit(fahrenheit));
    }

    public double celsiusValue() {
        return this.celsius;
    }

    public double fahrenheitValue() {
        return Temperature.fahrenheitFromCelsius(this.celsius);
    }

    public int hashCode() {
        return Objects.hash(this.celsius);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Temperature other = (Temperature)obj;
        return Double.doubleToLongBits(this.celsius) == Double.doubleToLongBits(other.celsius);
    }

    private Temperature(double celsius) {
        this.celsius = celsius;
    }

    private static double fahrenheitFromCelsius(double celsius) {
        return celsius * 1.8 + 32.0;
    }

    private static double celsiusFromFahrenheit(double fahrenheit) {
        return (fahrenheit - 32.0) * 5.0 / 9.0;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Temperature [celsius=").append(this.celsius).append("]");
        return builder.toString();
    }
}

