/*
 * Decompiled with CFR 0.152.
 */
package de.dhbw.ka.se2.vecto4j;

import de.dhbw.ka.se2.vecto4j.IncompleteVehicleException;
import de.dhbw.ka.se2.vecto4j.Simulator;
import de.dhbw.ka.se2.vecto4j.WrongVehicleClassException;
import de.dhbw.ka.se2.vecto4j.input.VehicleInput;
import de.dhbw.ka.se2.vecto4j.input.VehicleType;
import de.dhbw.ka.se2.vecto4j.output.EVScenarioResult;
import de.dhbw.ka.se2.vecto4j.output.ElectricVehicleSimulationResult;
import java.time.Duration;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.logging.Logger;

public class Co2Simulator
implements Simulator {
    private static final Logger LOG = Logger.getLogger(Co2Simulator.class.getName());
    private static final Duration AVG_SIMULATION_DURATION = Duration.ofSeconds(40L);
    private static final Duration AVG_SIMULATION_DEVIATION = Duration.ofSeconds(5L);
    private static final List<Integer> ALLOWED_VEHICLE_CLASSES = Arrays.asList(5, 9, 10, 12);
    private static final Map<Integer, Integer> VEHICLE_CLASS_SZENARIOS = Map.ofEntries(new AbstractMap.SimpleEntry<Integer, Integer>(1, 2), new AbstractMap.SimpleEntry<Integer, Integer>(2, 4), new AbstractMap.SimpleEntry<Integer, Integer>(3, 2), new AbstractMap.SimpleEntry<Integer, Integer>(4, 4), new AbstractMap.SimpleEntry<Integer, Integer>(5, 10), new AbstractMap.SimpleEntry<Integer, Integer>(9, 10), new AbstractMap.SimpleEntry<Integer, Integer>(10, 10), new AbstractMap.SimpleEntry<Integer, Integer>(11, 11), new AbstractMap.SimpleEntry<Integer, Integer>(12, 11));
    private final Random random = new Random();

    @Override
    public ElectricVehicleSimulationResult calculateVehicle(VehicleInput vehicle) throws IncompleteVehicleException, WrongVehicleClassException {
        this.checkVehicleCompleteness(vehicle);
        int vehicleClass = this.checkVehicleClass(vehicle);
        double duration = (double)AVG_SIMULATION_DURATION.toMillis() + this.random.nextGaussian() * (double)AVG_SIMULATION_DEVIATION.toMillis();
        try {
            Thread.sleep((long)duration);
        }
        catch (InterruptedException e) {
            LOG.severe(e.getMessage());
            Thread.currentThread().interrupt();
        }
        return this.makeRandomizedResponse(vehicle, vehicleClass);
    }

    private void checkVehicleCompleteness(VehicleInput vehicle) throws IncompleteVehicleException {
        if (null == vehicle) {
            throw new IncompleteVehicleException("Cannot simulate empty vehicles!");
        }
        if (null == vehicle.getType()) {
            throw new IncompleteVehicleException("Missing vehicle type!");
        }
        if (null == vehicle.getAirdrag()) {
            throw new IncompleteVehicleException("Missing airdrag data!");
        }
        if (null == vehicle.getAxles()) {
            throw new IncompleteVehicleException("Missing axle data!");
        }
        if (2 > vehicle.getAxles().size() || 4 < vehicle.getAxles().size()) {
            throw new IncompleteVehicleException("Incorrect number of axles provided: " + vehicle.getAxles().size());
        }
        if (null == vehicle.getBatteries()) {
            throw new IncompleteVehicleException("Missing battery data!");
        }
        if (1 > vehicle.getBatteries().size() || 5 < vehicle.getBatteries().size()) {
            throw new IncompleteVehicleException("Incorrect number of batteries provided: " + vehicle.getBatteries().size());
        }
        if (null == vehicle.getMotors()) {
            throw new IncompleteVehicleException("Missing motor data!");
        }
        if (1 > vehicle.getMotors().size() || vehicle.getAxles().size() * 2 < vehicle.getMotors().size()) {
            throw new IncompleteVehicleException("Incorrect number of motors provided: " + vehicle.getMotors().size() + " for " + vehicle.getAxles().size() + " axles.");
        }
        if (vehicle.getWeight() > vehicle.getMaxPermissibleWeight()) {
            throw new IncompleteVehicleException("Weight cannot be larger than max permissible weight!");
        }
    }

    private int checkVehicleClass(VehicleInput vehicle) throws WrongVehicleClassException, IncompleteVehicleException {
        int vehicleClass = this.calculateVehicleClass(vehicle);
        if (!ALLOWED_VEHICLE_CLASSES.contains(vehicleClass)) {
            throw new WrongVehicleClassException("Class " + vehicleClass + " is not allowed!");
        }
        return vehicleClass;
    }

    private int calculateVehicleClass(VehicleInput vehicle) throws IncompleteVehicleException {
        if (vehicle.getAxles().size() == 2) {
            if (vehicle.getMotors().size() == 1) {
                return this.calculate4x2VehicleClass(vehicle);
            }
            if (vehicle.getMotors().size() == 2) {
                return this.calculate4x4VehicleClass(vehicle);
            }
        }
        if (vehicle.getAxles().size() == 3) {
            return this.calculate6xVehicleClass(vehicle);
        }
        if (vehicle.getAxles().size() == 4) {
            return this.calculate8xVehicleClass(vehicle);
        }
        throw new IncompleteVehicleException("Vehicle class cannot be calculated!");
    }

    private int calculate4x2VehicleClass(VehicleInput vehicle) throws IncompleteVehicleException {
        if (vehicle.getType().equals((Object)VehicleType.LORRY) && 3500.0 < vehicle.getMaxPermissibleWeight() && 7500.0 < vehicle.getMaxPermissibleWeight()) {
            return 0;
        }
        if (7500.0 <= vehicle.getMaxPermissibleWeight() && vehicle.getMaxPermissibleWeight() <= 10000.0) {
            return 1;
        }
        if (10000.0 < vehicle.getMaxPermissibleWeight() && vehicle.getMaxPermissibleWeight() <= 12000.0) {
            return 2;
        }
        if (12000.0 < vehicle.getMaxPermissibleWeight() && vehicle.getMaxPermissibleWeight() <= 16000.0) {
            return 3;
        }
        if (16000.0 < vehicle.getMaxPermissibleWeight()) {
            if (vehicle.getType().equals((Object)VehicleType.LORRY)) {
                return 4;
            }
            if (vehicle.getType().equals((Object)VehicleType.TRACTOR)) {
                return 5;
            }
        }
        throw new IncompleteVehicleException("4x2 Vehicle class cannot be calculated!");
    }

    private int calculate4x4VehicleClass(VehicleInput vehicle) throws IncompleteVehicleException {
        if (vehicle.getType().equals((Object)VehicleType.LORRY)) {
            if (7500.0 <= vehicle.getMaxPermissibleWeight() && vehicle.getMaxPermissibleWeight() <= 16000.0) {
                return 6;
            }
            if (16000.0 < vehicle.getMaxPermissibleWeight()) {
                return 7;
            }
        }
        if (vehicle.getType().equals((Object)VehicleType.TRACTOR) && 16000.0 < vehicle.getMaxPermissibleWeight()) {
            return 8;
        }
        throw new IncompleteVehicleException("4x4 Vehicle class cannot be calculated!");
    }

    private int calculate6xVehicleClass(VehicleInput vehicle) throws IncompleteVehicleException {
        if (vehicle.getMotors().size() == 1) {
            if (vehicle.getType().equals((Object)VehicleType.LORRY)) {
                return 9;
            }
            if (vehicle.getType().equals((Object)VehicleType.TRACTOR)) {
                return 10;
            }
        }
        if (vehicle.getMotors().size() == 2) {
            if (vehicle.getType().equals((Object)VehicleType.LORRY)) {
                return 11;
            }
            if (vehicle.getType().equals((Object)VehicleType.TRACTOR)) {
                return 12;
            }
        }
        if (vehicle.getMotors().size() == 3) {
            if (vehicle.getType().equals((Object)VehicleType.LORRY)) {
                return 13;
            }
            if (vehicle.getType().equals((Object)VehicleType.TRACTOR)) {
                return 14;
            }
        }
        throw new IncompleteVehicleException("6x Vehicle class cannot be calculated!");
    }

    private int calculate8xVehicleClass(VehicleInput vehicle) throws IncompleteVehicleException {
        if (vehicle.getMotors().size() == 1) {
            return 15;
        }
        if (vehicle.getMotors().size() == 2) {
            return 16;
        }
        if (vehicle.getMotors().size() == 3 || vehicle.getMotors().size() == 4) {
            return 17;
        }
        throw new IncompleteVehicleException("8x Vehicle class cannot be calculated!");
    }

    private ElectricVehicleSimulationResult makeRandomizedResponse(VehicleInput vehicle, int vehicleClass) {
        ElectricVehicleSimulationResult response = new ElectricVehicleSimulationResult();
        response.setMinRange(100.0 + (double)vehicle.getBatteries().size() / (double)vehicle.getMotors().size() * 100.0 * this.random.nextGaussian());
        response.setMaxRange(300.0 + (double)vehicle.getBatteries().size() / (double)vehicle.getMotors().size() * 100.0 * this.random.nextGaussian());
        response.setSpecificRange(response.getMaxRange() - response.getMinRange() + (double)vehicle.getBatteries().size() / (double)vehicle.getMotors().size() * 100.0 * this.random.nextGaussian());
        response.setSpecificConsumption(50.0 + 50.0 * this.random.nextGaussian());
        response.setScenarios(this.makeRandomizedSzenarios(vehicle, vehicleClass));
        return response;
    }

    private List<EVScenarioResult> makeRandomizedSzenarios(VehicleInput vehicle, int vehicleClass) {
        int numberSzenarios = VEHICLE_CLASS_SZENARIOS.get(vehicleClass);
        ArrayList<EVScenarioResult> results = new ArrayList<EVScenarioResult>();
        for (int i = 0; i < numberSzenarios; ++i) {
            results.add(this.makeRandomizedSzenario(vehicle));
        }
        return results;
    }

    private EVScenarioResult makeRandomizedSzenario(VehicleInput vehicle) {
        EVScenarioResult response = new EVScenarioResult();
        response.setMinRange(100.0 + (double)vehicle.getBatteries().size() / (double)vehicle.getMotors().size() * 100.0 * this.random.nextGaussian());
        response.setMaxRange(300.0 + (double)vehicle.getBatteries().size() / (double)vehicle.getMotors().size() * 100.0 * this.random.nextGaussian());
        response.setAverageRange(response.getMaxRange() - response.getMinRange() + (double)vehicle.getBatteries().size() / (double)vehicle.getMotors().size() * 100.0 * this.random.nextGaussian());
        response.setConsumption(50.0 + 50.0 * this.random.nextGaussian());
        return response;
    }
}

